//update 2014.02.16



#ifndef(IDEAL_AREA_LIGHT_INC_TEMP)
#declare IDEAL_AREA_LIGHT_INC_TEMP = version;
#version 3.7;


#include "transforms.inc"

#ifndef(GOLDEN_RATIO)
    #declare GOLDEN_RATIO=(1+sqrt(5))/2;
#end



#macro Factor_ColorVsFadeDistance(FD)
(1/FD/FD/2)
#end




#macro Light_LambertianSphere(_color, _position, _radius, _resolution)
//adjust input
#local sphere_center=_position+<0,0,0>;
#if(_resolution<1)
    #local resolution=1;
#else
    #local resolution=int(_resolution);
#end
//local variables
#local emission_area=4*pi*_radius*_radius;  // unit^2
//make light sources
#if(resolution<2)
    light_source{
    <0,0,0>
    color (_color*emission_area/4/pi)*Factor_ColorVsFadeDistance(_radius/20)
    fade_power 2
    fade_distance _radius/20
    translate sphere_center 
    }
#else
    #for(i, 0, resolution-1)
        #local Z = -1+2*(1/2+i)/resolution;
        #local R = sqrt(1-Z*Z);
        #local Phi = i *2*pi*(1-1/GOLDEN_RATIO);
        #local ThisPoint = <cos(Phi)*R, sin(Phi)*R, Z>*_radius;
        light_source{
        <0,0,0>
        color (_color*emission_area/pi/resolution)*Factor_ColorVsFadeDistance(_radius/20)
        spotlight
        radius 90
        falloff 90
        tightness 1
        point_at ThisPoint
        fade_power 2
        fade_distance _radius/20
        translate sphere_center+ThisPoint
        }  
    #end
#end
//look like object
sphere{
sphere_center, _radius
pigment{color _color}
finish{ambient 0 diffuse 0 emission 1}
no_shadow
no_radiosity
}
#end


















#macro Light_LambertianCylinder(_color, _start_point, _end_point, _radius, _resolution)
//adjust input
#local start_p=_start_point+<0,0,0>;
#local end_p=_end_point+<0,0,0>;
#local total_lgth=vlength(start_p-end_p);
#if(total_lgth=0 | _radius<=0)
    #error "Light_LambertianCylinder macro error: Both radius and length must >0"
#end
#if(_resolution<1)
    #local resolution=1;
#else
    #local resolution=int(_resolution);
#end
//local variables associate with geometry
#local direct_v=vnormalize(end_p-start_p);
#local front_v=VPerp_To_Vector(direct_v);
#local emission_area=2*pi*_radius*total_lgth;
//make light sources
#if(resolution<2)
    light_source{
    <0,0,0>
    color (_color*emission_area/4/pi)*Factor_ColorVsFadeDistance(_radius/20)
    fade_power 2
    fade_distance _radius/20
    translate (end_p+start_p)/2
    }
#else
    #for(i, 0, resolution-1)
        #local pos_z = total_lgth*(1/2+i)/resolution;
        #local phi = i *2*pi*(1-1/GOLDEN_RATIO);
        #local distribution_point = <cos(phi)*_radius, sin(phi)*_radius, pos_z>;
        light_source{
        <0,0,pos_z>
        color (_color*emission_area/pi/resolution)*Factor_ColorVsFadeDistance(_radius/20)
        spotlight
        radius 90
        falloff 90
        tightness 1
        point_at distribution_point
        fade_power 2
        fade_distance _radius/20
        translate <cos(phi)*_radius, sin(phi)*_radius, 0>
        Shear_Trans(front_v, VPerp_To_Plane(direct_v, front_v), direct_v)
        translate start_p
        }  
    #end
#end
//look like object
cylinder{
start_p, end_p,
_radius
open
texture{
    pigment{color _color}
    finish{ambient 0 diffuse 0 emission 1}
}
interior_texture{
    pigment{rgb<0,0,0>}
    finish{ambient 0 diffuse 0 emission 0}
}
no_shadow
no_radiosity
}
#end







#macro Light_LambertianDisc(_color, _position, _face, _radius, _resolution)
//adjust input
#local disc_center=_position+<0,0,0>;
#local face_vector=_face+<0,0,0>;
#if(_resolution<1)
    #local resolution=1;
#else
    #local resolution=int(_resolution);
#end
#if(vlength(face_vector)=0)
    #local face_vector=<0,0,1>;
#else
    #local face_vector= vnormalize(face_vector);
#end

//local variables associate with geometry
#local emission_area=pi*_radius*_radius;
#if(vlength(face_vector-<0,0,1>)=0)
    #local rotate_axis=x;
    #local rotate_angle=0;
#elseif(vlength(face_vector-<0,0,-1>)=0)
    #local rotate_axis=x;
    #local rotate_angle=pi;
#else
    #local rotate_axis=vcross(<0,0,1>,face_vector);
    #local rotate_angle=acos(vdot(<0,0,1>,face_vector));
    #if(vdot(vcross(rotate_axis,<0,0,1>),face_vector)<0)
        #local rotate_angle=-rotate_angle;
    #end
#end

//make POV-Ray light sources
#if(resolution<2)
    light_source{
    <0,0,0>
    color (_color*emission_area/pi)*Factor_ColorVsFadeDistance(0.0001)
    spotlight
    radius 90
    falloff 90
    tightness 1
    point_at face_vector
    fade_power 2
    fade_distance 0.0001
    translate disc_center 
    }
#else
    #local GoldA = pi*(3-sqrt(5));
    #for(i, 0, resolution-1)
        #local R = sqrt(1/2+i)/sqrt(resolution);
        #local Theta = i*2*pi*(1-1/GOLDEN_RATIO);
        #local ThisPoint = <R*cos(Theta),R*sin(Theta),0>*_radius;
        #local ThisPoint=vaxis_rotate(ThisPoint,rotate_axis,degrees(rotate_angle));
        light_source{
        <0,0,0>
        color (_color*emission_area/pi/resolution)*Factor_ColorVsFadeDistance(0.0001)
        spotlight
        radius 90
        falloff 90
        tightness 1
        point_at face_vector
        fade_power 2
        fade_distance 0.0001
        translate disc_center+ThisPoint
        }
    #end
#end
//look like object
disc{
disc_center,
face_vector,
_radius,
texture{
    pigment{color _color}
    finish{ambient 0 diffuse 0 emission 1}
}
interior_texture{
    pigment{rgb<0,0,0>}
    finish{ambient 0 diffuse 0 emission 0}
}
no_shadow
no_radiosity
}
#end











#macro Light_InfiniteDome(_color, _sky, _place_distance, _resolution)
#local sky_v=_sky+<0,0,0>;
#if(_resolution<1)
    #local resolution=1;
#else
    #local resolution=int(_resolution);
#end
#if(vlength(sky_v)=0)
    #local sky_v=<0,0,1>;
#else
    #local sky_v= vnormalize(sky_v);
#end

#if(vlength(sky_v-<0,0,1>)=0)
    #local rotate_axis=x;
    #local rotate_angle=0;
#elseif(vlength(sky_v-<0,0,-1>)=0)
    #local rotate_axis=x;
    #local rotate_angle=pi;
#else
    #local rotate_axis=vcross(<0,0,1>,sky_v);
    #local rotate_angle=acos(vdot(<0,0,1>,sky_v));
    #if(vdot(vcross(rotate_axis,<0,0,1>),sky_v)<0)
        #local rotate_angle=-rotate_angle;
    #end
#end
//paralell lights
#for(i, 0, resolution-1)
    #local Z = (1/2+i)/resolution;
    #local R = sqrt(1-Z*Z);
    #local Phi = i *2*pi*(1-1/GOLDEN_RATIO);
    #local ThisPoint = <cos(Phi)*R, sin(Phi)*R, Z>*_place_distance;
    #local ThisPoint=vaxis_rotate(ThisPoint,rotate_axis,degrees(rotate_angle));
    light_source{
    ThisPoint
    color _color*2/_resolution
    parallel
    point_at <0,0,0>
    fade_power 0
    }  
#end
//look like background
#local vx=sky_v.x;
#local vy=sky_v.y;
#local vz=sky_v.z;

sphere{
<0,0,0>, _place_distance
texture{
    pigment{rgb<0,0,0>}
    finish{ambient 0 diffuse 0 emission 0}
}
interior_texture{
    pigment{
        function{
            select(vx*x+vy*y+vz*z,0,1)
        }
        color_map{
            [0 rgb<0,0,0>]
            [1 color _color]
        }
    }
    finish{ambient 0 diffuse 0 emission 1}
}
hollow
no_shadow
no_radiosity
}
#end







#macro Light_InfiniteSphere(_color, _place_distance, _resolution)
//adjust input
#if(_resolution<2)
    #local resolution=2;
#else
    #local resolution=int(_resolution);
#end
//parallel lights
#for(i, 0, resolution-1)
    #local Z = -1+2*(1/2+i)/resolution;
    #local R = sqrt(1-Z*Z);
    #local Phi = i *2*pi*(1-1/GOLDEN_RATIO);
    #local ThisPoint = <cos(Phi)*R, sin(Phi)*R, Z>*_place_distance;
    light_source{
    ThisPoint
    color _color*4/_resolution
    parallel
    point_at <0,0,0>
    fade_power 0
    }  
#end
//look like background
sphere{
<0,0,0>, _place_distance
texture{
    pigment{rgb<0,0,0>}
    finish{ambient 0 diffuse 0 emission 0}
}
interior_texture{
    pigment{color _color}
    finish{ambient 0 diffuse 0 emission 1}
}
hollow
no_shadow
no_radiosity
}
#end








#macro Light_InfiniteDisc(_color, _face, _place_distance, _solid_angle, _resolution)
//adjust input
#local solid_angle=abs(_solid_angle);
#local face_vector=_face+<0,0,0>;
#if(_resolution<1)
    #local resolution=1;
#else
    #local resolution=int(_resolution);
#end
#if(vlength(face_vector)=0)
    #local face_vector=<0,0,-1>;
#else
    #local face_vector= vnormalize(face_vector);
    #if(face_vector.z>0)
        #local face_vector=-face_vector;
    #end
#end
//local variables associate with geometry
#local center=-face_vector;
#local angular_diameter=2*acos(1-solid_angle/2/pi);
#if(vlength(face_vector-<0,0,-1>)=0)
    #local rotate_axis=x;
    #local rotate_angle=0;
#else
    #local rotate_axis=vcross(<0,0,1>,center);
    #local rotate_angle=acos(vdot(<0,0,1>,center));
#end
//make light sources
#if(resolution<2)
    light_source{
    center*_place_distance
    color _color*(1-cos(angular_diameter))/2
    parallel
    point_at <0,0,0>
    fade_power 0
    }
#else
    #for(i, 0, resolution-1)
        #local Z = cos(angular_diameter/2)+(1-cos(angular_diameter/2))*(1/2+i)/resolution;
        #local R = sqrt(1-Z*Z);
        #local Phi = i *2*pi*(1-1/GOLDEN_RATIO);
        #local ThisPoint = <cos(Phi)*R, sin(Phi)*R, Z>;
        #local ThisPoint=vaxis_rotate(ThisPoint,rotate_axis,degrees(rotate_angle))*_place_distance;
        light_source{
        ThisPoint
        color _color*(solid_angle/pi/resolution)
        parallel
        point_at <0,0,0>
        fade_power 0
        }  
    #end
#end
//look like object
sphere{
<0,0,0>,
_place_distance
clipped_by{
    cone{
    <0,0,0>,0,
    center*(_place_distance+0.1),(_place_distance+0.1)*tan(angular_diameter/2)
    }
}
texture{
    pigment{rgb<0,0,0>}
    finish{ambient 0 diffuse 0 emission 0}
}
interior_texture{
    pigment{color _color}
    finish{ambient 0 diffuse 0 emission 1}
}
no_shadow
no_radiosity
}
#end







#version IDEAL_AREA_LIGHT_INC_TEMP;
#end
